package com.ejie.aa94a.utils;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import com.ejie.aa94a.constantes.ConstantesPDF;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;

/**
 * Clase de utilidades para PDF
 * 
 * @author GFI
 * 
 */
public class UtilPDF {

	/**
	 * Constructor de UtilPDF
	 */
	private UtilPDF() {
	}

	/**
	 * Devuelve la fecha dada sumado los dias dados
	 * 
	 * @param fecha
	 *            Date
	 * @param dias
	 *            int
	 * @return Date
	 */
	public static Date addDaysToDate(Date fecha, int dias) {
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(fecha);
		cal.add(Calendar.DATE, dias);
		return cal.getTime();
	}

	// iText allows to add metadata to the PDF which can be viewed in your Adobe
	// Reader
	// under File -> Properties
	public static void addMetaData(Document document) throws DocumentException {

		document.addTitle(ConstantesPDF.DOC_TITULO);
		// document.addSubject("Using iText");
		document.addKeywords(ConstantesPDF.DOC_KEYWORDS);

	}

	public static void addTitlePage(Document document, String titulo, Font font)
			throws DocumentException {
		Paragraph preface = new Paragraph();
		// We add one empty line
		// addEmptyLine(preface, 1);
		// Lets write a big header
		preface.add(new Paragraph(titulo, font));

		// addEmptyLine(preface, 1);
		// // Will create: Report generated by: _name, _date
		// preface.add(new Paragraph(subtitulo,smallBold));
		// addEmptyLine(preface, 3);
		document.add(preface);
		// Start a new page
		// document.newPage();
	}

	/**
	 * 
	 */
	public static void addContent(Document document, PdfPTable table)
			throws DocumentException {

		Paragraph preface = new Paragraph();

		preface.add(table);

		// now add all this to the document
		document.add(preface);

	}

	/**
	 * parrafo vacio
	 * 
	 */
	public static void addParagraphEmpty(Document document)
			throws DocumentException {
		Paragraph preface = new Paragraph();
		// We add one empty line
		addEmptyLine(preface, 1);
		document.add(preface);
	}

	/**
	 * linea vacia
	 */
	private static void addEmptyLine(Paragraph paragraph, int number) {
		for (int i = 0; i < number; i++) {
			paragraph.add(new Paragraph(" ")); // NOPMD;
		}
	}

	/**
	 * Creamos estilo para las celdas de la tabla
	 * 
	 * 
	 * @param c1
	 * @return
	 */
	public static PdfPCell cssCeldas(PdfPCell c1) {
		c1.setPadding(4);
		c1.setBorderWidth(1);
		return c1;
	}

	/**
	 * Creamos estilo para la tabla
	 * 
	 * 
	 * @param table
	 * @return
	 */
	public static PdfPTable cssTabla(PdfPTable table) {
		table.setHeaderRows(1);
		table.setHeadersInEvent(true);
		table.setHorizontalAlignment(2);
		table.setWidthPercentage(100f);
		return table;
	}

	/**
	 * Creamos CONTENIDO PARA UNA CELDA
	 * 
	 * 
	 * @param table
	 * @return
	 */
	public static PdfPCell createCellContent(String text, Font font, int align,
			BaseColor myColor, int border) {
		PdfPCell c1 = new PdfPCell(new Phrase(text, font));
		c1.setHorizontalAlignment(align);
		c1.setBackgroundColor(myColor);
		c1.setBorder(border);
		return c1;
	}

	/**
	 * Creamos CONTENIDO PARA UNA CELDA
	 * 
	 * 
	 * @param table
	 * @return
	 */
	public static PdfPCell createCellContentParagraf(Paragraph text, int align,
			BaseColor myColor, int border) {
		PdfPCell c1 = new PdfPCell(text);
		c1.setHorizontalAlignment(align);
		c1.setBackgroundColor(myColor);
		c1.setBorder(border);
		return c1;
	}

	/**
	 * Creamos CONTENIDO PARA UNA CELDA
	 * 
	 * @param text
	 *            Paragraph
	 * @param align
	 *            int
	 * @param myColor
	 *            BaseColor
	 * @param border
	 *            int
	 * @param mostrarGraficos
	 *            boolean
	 * @return PdfPCell
	 */
	public static PdfPCell createCellContentParagraf(Paragraph text, int align,
			BaseColor myColor, int border, boolean mostrarGraficos) {
		PdfPCell c1 = new PdfPCell(text);
		c1.setHorizontalAlignment(align);
		c1.setBackgroundColor(myColor);
		c1.setBorder(border);
		c1.setColspan(mostrarGraficos ? 1 : 2);
		return c1;
	}

	public static final BaseColor AZUL = new BaseColor(51, 122, 183);

	/**
	 * Creamos CONTENIDO PARA UNA CELDA con una tabla
	 * 
	 * 
	 * @param table
	 * @return
	 */
	public static PdfPCell createCellContentParagrafTable(PdfPTable table,
			int align, BaseColor myColor, int border) {
		PdfPCell c1 = new PdfPCell(table);
		c1.setHorizontalAlignment(align);
		c1.setBackgroundColor(myColor);
		c1.setBorder(border);
		return c1;
	}

	/**
	 * 
	 * @return
	 * @throws DocumentException
	 */
	public static PdfPTable createTablePresentacion(int columnas,
			float[] anchoColumnas) throws DocumentException {

		PdfPTable table = new PdfPTable(columnas);
		// ANCHO DE LAS COLUMNAS
		table.setWidths(anchoColumnas);
		table.setHorizontalAlignment(2);
		table.setWidthPercentage(100f);
		return table;
	}

	public static PdfPTable createTablePresentacion2(int columnas,
			float[] anchoColumnas) throws DocumentException {

		PdfPTable table = new PdfPTable(columnas);
		// ANCHO DE LAS COLUMNAS
		table.setWidths(anchoColumnas);
		table.setHorizontalAlignment(3);
		table.setWidthPercentage(80f);
		return table;
	}

	/**
	 * 
	 * @param fileName
	 */
	public static void deletePDF(String fileName) {

		// A File object to represent the filename
		File f = new File(fileName);

		// Make sure the file or directory exists and isn't write protected
		if (!f.exists())
			throw new IllegalArgumentException(
					"Delete: no such file or directory: " + fileName);

		if (!f.canWrite())
			throw new IllegalArgumentException("Delete: write protected: "
					+ fileName);

		// If it is a directory, make sure it is empty
		if (f.isDirectory()) {
			String[] files = f.list();
			if (files.length > 0)
				throw new IllegalArgumentException(
						"Delete: directory not empty: " + fileName);
		}

		// Attempt to delete it
		boolean success = f.delete();

		if (!success)
			throw new IllegalArgumentException("Delete: deletion failed");
	}

}